"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var action_exports = {};
__export(action_exports, {
  actionTelemetry: () => actionTelemetry
});
module.exports = __toCommonJS(action_exports);
var import_logging = require("genkit/logging");
var import_tracing = require("genkit/tracing");
var import_utils = require("../utils.js");
class ActionTelemetry {
  tick(span, logInputAndOutput, projectId) {
    if (!logInputAndOutput) {
      return;
    }
    const attributes = span.attributes;
    const actionName = attributes["genkit:name"] || "<unknown>";
    const subtype = attributes["genkit:metadata:subtype"];
    if (subtype === "tool" || actionName === "generate") {
      const path = attributes["genkit:path"] || "<unknown>";
      const input = (0, import_utils.truncate)(attributes["genkit:input"]);
      const output = (0, import_utils.truncate)(attributes["genkit:output"]);
      const sessionId = attributes["genkit:sessionId"];
      const threadName = attributes["genkit:threadName"];
      let featureName = (0, import_utils.extractOuterFeatureNameFromPath)(path);
      if (!featureName || featureName === "<unknown>") {
        featureName = actionName;
      }
      if (input) {
        this.writeLog(
          span,
          "Input",
          featureName,
          path,
          input,
          projectId,
          sessionId,
          threadName
        );
      }
      if (output) {
        this.writeLog(
          span,
          "Output",
          featureName,
          path,
          output,
          projectId,
          sessionId,
          threadName
        );
      }
    }
  }
  writeLog(span, tag, featureName, qualifiedPath, content, projectId, sessionId, threadName) {
    const path = (0, import_utils.truncatePath)((0, import_tracing.toDisplayPath)(qualifiedPath));
    const sharedMetadata = {
      ...(0, import_utils.createCommonLogAttributes)(span, projectId),
      path,
      qualifiedPath,
      featureName,
      sessionId,
      threadName
    };
    import_logging.logger.logStructured(`${tag}[${path}, ${featureName}]`, {
      ...sharedMetadata,
      content
    });
  }
}
const actionTelemetry = new ActionTelemetry();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  actionTelemetry
});
//# sourceMappingURL=action.js.map